' ------------------------------------------------------------------------------------------------
' Advanced Text Info output
' ------------------------------------------------------------------------------------------------
Type TInfo



	Field Scale:Int										' line height
	Field lineoffset:Int								' line offset
	Field rgb:Int[]										' text color
	Field sha:Int[]										' shadow color
	Field shadow:Int									' shadow flag
	Field shadowoffset:Int								' shadow offset
	Field output:String									' text output
	Field align:String									' centered text
	Field a:Float 										' alpha value
	Field bar:Int
	Field baroffx:Int
	Field baroffy:Int
	Field barrgb:Int[]									' bar color
	Field offx:Int
	Field offy:Int
	Field upp:Int
	Field col:Int

	Global list:TList = CreateList()



	' --------------------------------------------------------------------------------------------
	' METHOD: Create new Object in TList
	' --------------------------------------------------------------------------------------------
	Method New()
	
		ListAddLast(list, Self)

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Remove Object from TList
	' --------------------------------------------------------------------------------------------
	Method Remove()

		'ListRemove(list, Self)

	End Method
	
	

	' --------------------------------------------------------------------------------------------
	' METHOD: Reset current Object to defaults
	' --------------------------------------------------------------------------------------------
	Method reset()
	
		Scale = 18
		lineoffset = Null
		rgb = [255, 255, 255]
		sha = [0, 0, 0]
		shadow = False
		shadowoffset = 1
		output = ""
		align = "left"
		a = 1.0
		bar = False
		baroffx = 0
		baroffy = 0
		barrgb = [255, 255, 255]
		offx = 0
		offy = 0
		upp = False
		col = False
	
	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Add Text line
	' --------------------------------------------------------------------------------------------
	Method Add(output:String, lineoffset:Int = Null, align:String = "left", r:Int = Null, g:Int = Null, b:Int = Null,a:Float=1.0)

		Local i:TInfo = New TInfo
		i.output = output
		If lineoffset <> Null Then i.lineoffset = lineoffset
		i.align = align
		If a Then i.a = a
		i.col = False
		If r Or g Or b Then i.rgb = [r, g, b] ; i.col = True

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Output Text
	' --------------------------------------------------------------------------------------------
	Method Update()

		Local cnt:Int = 0
		Local sx:Int
		Local sy:Int
				
		For Local i:TInfo = EachIn TInfo.list

			If i.output Then
			
				SetBlend ALPHABLEND

				Local box:Int = baroffx / 2
				Local boy:Int = baroffy / 2

				If upp Then i.output = Upper(i.output)

				If i.lineoffset Then cnt:+i.lineoffset
				
				sx = offx
				sy = offy + cnt
				
				If i.align = "center" Then sx = width / 2 - TextWidth(i.output) / 2
				If i.align = "right" Then sx:-TextWidth(i.output)
				
				If bar Then
				
					SetColor(barrgb[0], barrgb[1], barrgb[2])
					SetAlpha(0.7)
					DrawRect(sx - box, sy + 2, TextWidth(i.output) + (box * 1.5), TextHeight(i.output) - 2)
				
				End If
								
				SetAlpha i.a

				' shadow text first
				If shadow Then

					SetColor sha[0], sha[1], sha[2]
					DrawText i.output, sx + shadowoffset, sy + shadowoffset

					DrawText i.output, sx - shadowoffset, sy - shadowoffset
					
					DrawText i.output, sx + shadowoffset, sy - shadowoffset
					
					DrawText i.output, sx - shadowoffset, sy + shadowoffset

				EndIf

				' normal text
				SetColor rgb[0], rgb[1], rgb[2]
				
				If i.col Then SetColor i.rgb[0], i.rgb[1], i.rgb[2]
								
				DrawText i.output, sx, sy

				cnt:+Scale

			EndIf

			' remove line from list = clear
			'i.Remove()
			ListRemove(list, i)
			i = Null
			
		Next
		
		GCCollect()
		
		SetBlend SOLIDBLEND

	End Method



End Type